//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TypeTable.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 21:48:32 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 17 21:49:49 2015
// Update Count     : 2
//

#ifndef TYPETABLE_H
#define TYPETABLE_H

#include <cassert>
#include <map>
#include <stack>
#include <string>
#include <functional>

#include "StackTable.h"
#include "SynTree/Declaration.h"

namespace SymTab {
    class TypeTableConflictFunction : public std::binary_function< NamedTypeDecl *, NamedTypeDecl *, NamedTypeDecl * > {
      public:
		NamedTypeDecl *operator()( NamedTypeDecl *existing, NamedTypeDecl *added ) {
			if ( existing->get_base() == 0 ) {
				return added;
			} else if ( added->get_base() == 0 ) {
				return existing;
			} else {
				throw SemanticError( "redeclaration of ", added );
			} // if
			assert( false );
			return 0;
		}
    };

    typedef StackTable< NamedTypeDecl, TypeTableConflictFunction > TypeTable;
} // namespace SymTab

#endif // TYPETABLE_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
