#include <cstdio>
#include <mutex>
#include <thread>
#include <chrono>
#include "../bench.h"
#include "cppLock.hpp"

cpp_test_spinlock LOCKS;

bool done = false;
uint64_t total = 0;
void thread_main() {
    BENCH( lock( LOCKS ); unlock( LOCKS );, total, done )
}

int main( int argc, char * argv[] ) {
	BENCH_START()
    std::thread myThreads[threads];

    for (int i = 0; i < threads; i++) {
        myThreads[i] = std::thread(thread_main); // move constructed
    }

    std::this_thread::sleep_for (std::chrono::seconds(10));
    done = true;
    
    for (int i = 0; i < threads; i++) {
        myThreads[i].join();
    }

	printf( "%lu\n", total );
}

// Local Variables: //
// tab-width: 4 //
// End: //
