#! /usr/bin/python3

import glob
import os
import re

print("corpuslen", "expansion", "elapsed_whole_test", "elapsed_last_alloc", "seclast_req_mem", sep=",")

thepath = "preload_dump--qrun1*"

for mypath in glob.glob(thepath):
    pathparsed=re.match(r'preload_dump--qrun1--corpus-1-(\d+)-1.txt--expansion-(0\.\d+).txt', mypath)
    corpuslen=pathparsed.group(1)
    expansion=pathparsed.group(2)

    with open(mypath) as file:
        lines = file.readlines()

        nAllocs = len(lines)

        epoch_timestamp_bp = lines[0].find("epoch_timestamp(ms)")
        epoch_timestamp_ep = epoch_timestamp_bp + len("epoch_timestamp(ms)")
        current_req_mem_bp = lines[0].find("current_req_mem(B)")
        current_req_mem_ep = current_req_mem_bp + len("current_req_mem(B)")
        
        first_timestamp   = lines[        1][epoch_timestamp_bp:epoch_timestamp_ep].strip()
        seclast_req_mem   = lines[nAllocs-2][current_req_mem_bp:current_req_mem_ep].strip()
        seclast_timestamp = lines[nAllocs-2][epoch_timestamp_bp:epoch_timestamp_ep].strip()
        last_timestamp    = lines[nAllocs-1][epoch_timestamp_bp:epoch_timestamp_ep].strip()

        elapsed_whole_test = int(last_timestamp) - int(first_timestamp)
        elapsed_last_alloc = int(last_timestamp) - int(seclast_timestamp)

        print(corpuslen, expansion, elapsed_whole_test, elapsed_last_alloc, seclast_req_mem, sep=",")
