#!/bin/bash

# $1 is SUT id     : stl-pall-na-na-na
# $2 is CLI middle : 1000 1.006 0.1 -w 10000000
# $3 is corpus id  : -1-500-1  (goes with corpus-1-500-1.txt)
#
# usage for that example:   ./make-flamegraph.sh cfa-pall-ll-share-na '1000 1.006 0.1 -w 10000000' -1-500-1
#
# another
# $3 is coprus id  : x-100-20-1  (goes with corpusx-100-20-1.txt)

SLUG=perf--$1--${2//[ .]/-}--$3

perf record --call-graph dwarf -m16M ~/plg2/cfa2/cfa-cc/tests/zombies/string-perf/perfexp-$1 $2 `cat ~/plg2/cfa2/cfa-cc/tests/zombies/string-perf/corpus$3.txt`

mv perf.data $SLUG.data
perf script -i $SLUG.data > $SLUG.perf
../flamegraph/FlameGraph/stackcollapse-perf.pl $SLUG.perf > $SLUG.folded
../flamegraph/FlameGraph/flamegraph.pl $SLUG.folded > $SLUG.svg
cp $SLUG.svg ~/plg2/flames
