//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// exception.h -- Builtins for exception handling.
//
// Author           : Andrew Beach
// Created On       : Mon Jun 26 15:11:00 2017
// Last Modified By : Andrew Beach
// Last Modified On : Thr Aug 17 15:44:00 2017
// Update Count     : 6
//

#pragma once


#ifdef __cforall
extern "C" {
#endif

struct __cfaehm__base_exception_t;
typedef struct __cfaehm__base_exception_t exception;
struct __cfaehm__base_exception_t_vtable {
	const struct __cfaehm__base_exception_t_vtable * parent;
	size_t size;
	void (*copy)(struct __cfaehm__base_exception_t *this,
	             struct __cfaehm__base_exception_t * other);
	void (*free)(struct __cfaehm__base_exception_t *this);
	const char * (*msg)(struct __cfaehm__base_exception_t *this);
};
struct __cfaehm__base_exception_t {
	struct __cfaehm__base_exception_t_vtable const * virtual_table;
};
extern struct __cfaehm__base_exception_t_vtable
	___cfaehm__base_exception_t_vtable_instance;


// Used in throw statement translation.
void __cfaehm__throw_terminate(exception * except) __attribute__((noreturn));
void __cfaehm__rethrow_terminate() __attribute__((noreturn));
void __cfaehm__throw_resume(exception * except);

// Function catches termination exceptions.
void __cfaehm__try_terminate(
    void (*try_block)(),
    void (*catch_block)(int index, exception * except),
    int (*match_block)(exception * except));

// Clean-up the exception in catch blocks.
void __cfaehm__cleanup_terminate(void * except);

// Data structure creates a list of resume handlers.
struct __cfaehm__try_resume_node {
    struct __cfaehm__try_resume_node * next;
    _Bool (*handler)(exception * except);
};

// These act as constructor and destructor for the resume node.
void __cfaehm__try_resume_setup(
    struct __cfaehm__try_resume_node * node,
    _Bool (*handler)(exception * except));
void __cfaehm__try_resume_cleanup(
    struct __cfaehm__try_resume_node * node);

// Check for a standard way to call fake deconstructors.
struct __cfaehm__cleanup_hook {};

#ifdef __cforall
}
#endif
