typedef forall ( type T ) int (*f)( int );

forall( type T )
void swap( T left, T right ) {
	T temp = left;
	left = right;
	right = temp;
}

context sumable( type T ) {
	const T 0;
	T ?+?(T, T);
	T ?++(T);
	[T] ?+=?(T,T);
};

type T1 | { const T1 0; T1 ?+?(T1, T1); T1 ?++(T1); [T1] ?+=?(T1,T1); },
	T2(type P1, type P2 ),
	T3 | sumable(T3);

type T2(type P1, type P2) | sumable(T2(P1,P2)) = struct { P1 i; P2 j; };

T2(int, int) w1;
typedef T2(int, int) w2;
w2 g2;
type w3 = T2(int, int);
w3 g3;

forall( type T | sumable( T ) )
T sum( int n, T a[] ) {
	T total = 0;
	int i;
	for ( i = 0; i < n; i += 1 )
		total = total + a[i];
	return total;
}

forall( type T | { const T 0; T ?+?(T, T); T ?++(T); [T] ?+=?(T,T); } )
T twice( T t ) {
	return t + t;
}

forall( type T | { const T 0; int ?!=?(T, T); int ?<?(T, T); } )
T min( T t1, T t2 ) {
	return t1 < t2 ? t1 : t2;
}

int main() {
	int x = 1, y = 2, a[10];
	float f;

	swap( x, y );
	twice( x );
	f = min( 4.0, 3.0 );
	sum( 10, a );
}

// Local Variables: //
// tab-width: 4 //
// End: //
