import os

from pybin.tools import *


# Test class that defines what a test is
class Test:
	def __init__(self):
		self.name = ''
		self.path = ''
		self.arch = ''

	def toString(self):
		return "{:25s} ({:5s} {:s})".format( self.name, self.arch if self.arch else "Any", self.target() )

	def prepare(self, dry_run):
		sh("mkdir -p %s" % os.path.join(self.path, '.err'), dry_run)
		sh("mkdir -p %s" % os.path.join(self.path, '.out'), dry_run)
		sh("mkdir -p %s" % os.path.join(self.path, '.in' ), dry_run)

	def expect_file(self):
		return ("%s/.expect/%s.txt" % (self.path, self.name))

	def error_file(self):
		return ("%s/.err/%s.log"    % (self.path, self.name))

	def output_file(self):
		return ("%s/.out/%s.log"    % (self.path, self.name))

	def input_file(self):
		return ("%s/.in/%s.txt"     % (self.path, self.name))

	def target(self):
		return os.path.join(self.path, self.name)