//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// iostream.c --
//
// Author           : Peter A. Buhr
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Dec  6 23:03:43 2017
// Update Count     : 426
//

#include "iostream"

extern "C" {
#include <stdio.h>
#include <stdbool.h>									// true/false
#include <string.h>										// strlen
#include <float.h>										// DBL_DIG, LDBL_DIG
#include <complex.h>									// creal, cimag
}

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, char ch ) {
	fmt( os, "%c", ch );
	if ( ch == '\n' ) setNL( os, true );
	sepOff( os );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, signed char c ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%hhd", c );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, unsigned char c ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%hhu", c );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, short int si ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%hd", si );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, unsigned short int usi ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%hu", usi );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, int i ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%d", i );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, unsigned int ui ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%u", ui );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, long int li ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%ld", li );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, unsigned long int uli ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%lu", uli );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, long long int lli ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%lld", lli );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, unsigned long long int ulli ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%llu", ulli );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, float f ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%g", f );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, double d ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%.*lg", DBL_DIG, d );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, long double ld ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%.*Lg", LDBL_DIG, ld );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, float _Complex fc ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%g%+gi", crealf( fc ), cimagf( fc ) );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, double _Complex dc ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%.*lg%+.*lgi", DBL_DIG, creal( dc ), DBL_DIG, cimag( dc ) );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, long double _Complex ldc ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%.*Lg%+.*Lgi", LDBL_DIG, creall( ldc ), LDBL_DIG, cimagl( ldc ) );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, const char * str ) {
	enum { Open = 1, Close, OpenClose };
	static const unsigned char mask[256] @= {
		// opening delimiters, no space after
		['('] : Open, ['['] : Open, ['{'] : Open,
		['='] : Open, ['$'] : Open, [(unsigned char)''] : Open, [(unsigned char)''] : Open,
		[(unsigned char)''] : Open, [(unsigned char)''] : Open, [(unsigned char)''] : Open,
		// closing delimiters, no space before
		[','] : Close, ['.'] : Close, [';'] : Close, ['!'] : Close, ['?'] : Close,
		['%'] : Close, [(unsigned char)''] : Close, [(unsigned char)''] : Close,
		[')'] : Close, [']'] : Close, ['}'] : Close,
		// opening-closing delimiters, no space before or after
		['\''] : OpenClose, ['`'] : OpenClose, ['"'] : OpenClose, [':'] : OpenClose,
		[' '] : OpenClose, ['\f'] : OpenClose, ['\n'] : OpenClose, ['\r'] : OpenClose, ['\t'] : OpenClose, ['\v'] : OpenClose, // isspace
	}; // mask

  if ( str[0] == '\0' ) { sepOff( os ); return os; }		// null string => no separator

	// first character IS NOT spacing or closing punctuation => add left separator
	unsigned char ch = str[0];							// must make unsigned
	if ( sepPrt( os ) && mask[ ch ] != Close && mask[ ch ] != OpenClose ) {
		fmt( os, "%s", sepGetCur( os ) );
	} // if

	// if string starts line, must reset to determine open state because separator is off
	sepReset( os );										// reset separator

	// last character IS spacing or opening punctuation => turn off separator for next item
	size_t len = strlen( str );
	ch = str[len - 1];									// must make unsigned
	if ( sepPrt( os ) && mask[ ch ] != Open && mask[ ch ] != OpenClose ) {
		sepOn( os );
	} else {
		sepOff( os );
	} // if
	if ( ch == '\n' ) setNL( os, true );				// check *AFTER* sepPrt call above as it resets NL flag
	return write( os, str, len );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, const char16_t * str ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%ls", str );
	return os;
} // ?|?

#if ! ( __ARM_ARCH_ISA_ARM == 1 && __ARM_32BIT_STATE == 1 ) // char32_t == wchar_t => ambiguous
forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, const char32_t * str ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%ls", str );
	return os;
} // ?|?
#endif // ! ( __ARM_ARCH_ISA_ARM == 1 && __ARM_32BIT_STATE == 1 )

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, const wchar_t * str ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%ls", str );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, const void * p ) {
	if ( sepPrt( os ) ) fmt( os, "%s", sepGetCur( os ) );
	fmt( os, "%p", p );
	return os;
} // ?|?


// tuples
forall( dtype ostype, otype T, ttype Params | writeable( T, ostype ) | { ostype & ?|?( ostype &, Params ); } )
ostype & ?|?( ostype & os, T arg, Params rest ) {
	os | arg;											// print first argument
	sepSetCur( os, sepGetTuple( os ) );					// switch to tuple separator
	os | rest;											// print remaining arguments
	sepSetCur( os, sepGet( os ) );						// switch to regular separator
	return os;
} // ?|?


// manipulators
forall( dtype ostype | ostream( ostype ) )
ostype & ?|?( ostype & os, ostype & (* manip)( ostype & ) ) {
	return manip( os );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype & sep( ostype & os ) {
	os | sepGet( os );
	return os;
} // sep

forall( dtype ostype | ostream( ostype ) )
ostype & sepTuple( ostype & os ) {
	os | sepGetTuple( os );
	return os;
} // sepTuple

forall( dtype ostype | ostream( ostype ) )
ostype & endl( ostype & os ) {
	os | '\n';
	setNL( os, true );
	flush( os );
	sepOff( os );										// prepare for next line
	return os;
} // endl

forall( dtype ostype | ostream( ostype ) )
ostype & sepOn( ostype & os ) {
	sepOn( os );
	return os;
} // sepOn

forall( dtype ostype | ostream( ostype ) )
ostype & sepOff( ostype & os ) {
	sepOff( os );
	return os;
} // sepOff

forall( dtype ostype | ostream( ostype ) )
ostype & sepEnable( ostype & os ) {
	sepEnable( os );
	return os;
} // sepEnable

forall( dtype ostype | ostream( ostype ) )
ostype & sepDisable( ostype & os ) {
	sepDisable( os );
	return os;
} // sepDisable

//---------------------------------------

forall( dtype ostype, otype elt_type | writeable( elt_type, ostype ), otype iterator_type | iterator( iterator_type, elt_type ) )
void write( iterator_type begin, iterator_type end, ostype & os ) {
	void print( elt_type i ) { os | i; }
	for_each( begin, end, print );
} // ?|?

forall( dtype ostype, otype elt_type | writeable( elt_type, ostype ), otype iterator_type | iterator( iterator_type, elt_type ) )
void write_reverse( iterator_type begin, iterator_type end, ostype & os ) {
	void print( elt_type i ) { os | i; }
	for_each_reverse( begin, end, print );
} // ?|?

//---------------------------------------

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, char & c ) {
	fmt( is, "%c", &c );								// must pass pointer through varg to fmt
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, signed char & sc ) {
	fmt( is, "%hhd", &sc );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, unsigned char & usc ) {
	fmt( is, "%hhu", &usc );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, short int & si ) {
	fmt( is, "%hd", &si );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, unsigned short int & usi ) {
	fmt( is, "%hu", &usi );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, int & i ) {
	fmt( is, "%d", &i );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, unsigned int & ui ) {
	fmt( is, "%u", &ui );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, long int & li ) {
	fmt( is, "%ld", &li );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, unsigned long int & ulli ) {
	fmt( is, "%lu", &ulli );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, long long int & lli ) {
	fmt( is, "%lld", &lli );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, unsigned long long int & ulli ) {
	fmt( is, "%llu", &ulli );
	return is;
} // ?|?


forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, float & f ) {
	fmt( is, "%f", &f );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, double & d ) {
	fmt( is, "%lf", &d );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, long double & ld ) {
	fmt( is, "%Lf", &ld );
	return is;
} // ?|?


forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, float _Complex & fc ) {
	float re, im;
	fmt( is, "%g%gi", &re, &im );
	fc = re + im * _Complex_I;
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, double _Complex & dc ) {
	double re, im;
	fmt( is, "%lf%lfi", &re, &im );
	dc = re + im * _Complex_I;
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, long double _Complex & ldc ) {
	long double re, im;
	fmt( is, "%Lf%Lfi", &re, &im );
	ldc = re + im * _Complex_I;
	return is;
} // ?|?

_Istream_cstrUC cstr( char * str ) { return (_Istream_cstrUC){ str }; }
forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, _Istream_cstrUC cstr ) {
	fmt( is, "%s", cstr.s );
	return is;
} // cstr

_Istream_cstrC cstr( char * str, int size ) { return (_Istream_cstrC){ str, size }; }
forall( dtype istype | istream( istype ) )
istype & ?|?( istype & is, _Istream_cstrC cstr ) {
	char buf[16];
	sprintf( buf, "%%%ds", cstr.size );
	fmt( is, buf, cstr.s );
	return is;
} // cstr

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa iostream.c" //
// End: //
