//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ConversionCost.h --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 09:37:28 2015
// Last Modified By : Andrew Beach
// Last Modified On : Mon Jun 24 10:00:00 2019
// Update Count     : 5
//

#pragma once

#include <functional>         // for function

#include "Cost.h"             // for Cost

#include "AST/Fwd.hpp"
#include "AST/Pass.hpp"       // for WithShortCircuiting
#include "Common/PassVisitor.h"
#include "SynTree/Visitor.h"  // for Visitor
#include "SynTree/SynTree.h"  // for Visitor Nodes

namespace SymTab {
	class Indexer;
}  // namespace SymTab

namespace ResolvExpr {
	class TypeEnvironment;

	typedef std::function<Cost(Type *, Type *, const SymTab::Indexer &, const TypeEnvironment &)> CostFunction;
	struct ConversionCost : public WithShortCircuiting {
	  public:
		ConversionCost( Type *dest, const SymTab::Indexer &indexer, const TypeEnvironment &env, CostFunction );

		Cost get_cost() const { return cost; }

		void previsit( BaseSyntaxNode * ) { visit_children = false; }

		void postvisit( VoidType * voidType );
		void postvisit( BasicType * basicType );
		void postvisit( PointerType * pointerType );
		void postvisit( ArrayType * arrayType );
		void postvisit( ReferenceType * refType );
		void postvisit( FunctionType * functionType );
		void postvisit( StructInstType * aggregateUseType );
		void postvisit( UnionInstType * aggregateUseType );
		void postvisit( EnumInstType * aggregateUseType );
		void postvisit( TraitInstType * aggregateUseType );
		void postvisit( TypeInstType * aggregateUseType );
		void postvisit( TupleType * tupleType );
		void postvisit( VarArgsType * varArgsType );
		void postvisit( ZeroType * zeroType );
		void postvisit( OneType * oneType );
	  protected:
		Type *dest;
		const SymTab::Indexer &indexer;
		Cost cost;
		const TypeEnvironment &env;
		CostFunction costFunc;
	};

	typedef std::function<int(Type *, Type *, const SymTab::Indexer &, const TypeEnvironment &)> PtrsFunction;
	Cost convertToReferenceCost( Type * src, ReferenceType * dest, const SymTab::Indexer & indexer, const TypeEnvironment & env, PtrsFunction func );

// Some function pointer types, differ in return type.
using CostCalculation = std::function<Cost(const ast::Type *, const ast::Type *,
	const ast::SymbolTable &, const ast::TypeEnvironment &)>;
using NumCostCalculation = std::function<int(const ast::Type *, const ast::Type *,
	const ast::SymbolTable &, const ast::TypeEnvironment &)>;

// TODO: When the old ConversionCost is removed, get ride of the _new suffix.
class ConversionCost_new : public ast::WithShortCircuiting {
	const ast::Type * dst;
	const ast::SymbolTable & symtab;
	const ast::TypeEnvironment & env;
	CostCalculation costCalc;
public:
	Cost cost;

	ConversionCost_new( const ast::Type * dst, const ast::SymbolTable & symtab,
			const ast::TypeEnvironment & env, CostCalculation costCalc ) :
		dst( dst ), symtab( symtab ), env( env ), costCalc( costCalc ), cost( Cost::infinity )
	{}

	void previsit( const ast::Node * ) { visit_children = false; }

	void postvisit( const ast::VoidType * voidType );
	void postvisit( const ast::BasicType * basicType );
	void postvisit( const ast::PointerType * pointerType );
	void postvisit( const ast::ArrayType * arrayType );
	void postvisit( const ast::ReferenceType * refType );
	void postvisit( const ast::FunctionType * functionType );
	void postvisit( const ast::StructInstType * structInstType );
	void postvisit( const ast::UnionInstType * unionInstType );
	void postvisit( const ast::EnumInstType * enumInstType );
	void postvisit( const ast::TraitInstType * traitInstType );
	void postvisit( const ast::TypeInstType * typeInstType );
	void postvisit( const ast::TupleType * tupleType );
	void postvisit( const ast::VarArgsType * varArgsType );
	void postvisit( const ast::ZeroType * zeroType );
	void postvisit( const ast::OneType * oneType );
};

Cost convertToReferenceCost( const ast::Type * src, const ast::ReferenceType * dest,
	const ast::SymbolTable & indexer, const ast::TypeEnvironment & env, NumCostCalculation func );

} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
