// 
// Cforall Version 1.0.0 Copyright (C) 2018 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// time_t.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Tue Apr 10 14:42:03 2018
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Apr 13 07:51:47 2018
// Update Count     : 6
// 

#pragma once


//######################### Duration #########################

struct Duration {										// private
	int64_t tv;											// nanoseconds
}; // Duration

static inline void ?{}( Duration & dur ) with( dur ) { tv = 0; }
static inline void ?{}( Duration & dur, zero_t ) with( dur ) { tv = 0; }


//######################### Time #########################

struct Time {											// private
	uint64_t tv;										// nanoseconds since UNIX epoch
}; // Time

static inline void ?{}( Time & time ) with( time ) { tv = 0; }
static inline void ?{}( Time & time, zero_t ) with( time ) { tv = 0; }

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
