#include <kernel>
#include <thread>

#ifndef PREEMPTION_RATE
#define PREEMPTION_RATE 10_000ul
#endif

unsigned int default_preemption() {
	return PREEMPTION_RATE;
}

static volatile int counter = 0;

thread Worker {
	int value;
};

void ?{}( Worker * this, int value ) {
	this->value = value;
}

void main(Worker * this) {
	while(counter < 1000) {
		if( (counter % 7) == this->value ) {
			int next = __atomic_add_fetch_4(&counter, 1, __ATOMIC_SEQ_CST);
			if( (next % 100) == 0 ) printf("%d\n", next);
		}
	}
}

int main(int argc, char* argv[]) {
	processor p;
	{
		Worker w0 = 0;
		Worker w1 = 1;
		Worker w2 = 2;
		Worker w3 = 3;
		Worker w4 = 4;
		Worker w5 = 5;
		Worker w6 = 6;
	}
}