// 
// Cforall Version 1.0.0 Copyright (C) 2017 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// waitfor.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Aug 30 17:53:29 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Aug 30 17:55:17 2017
// Update Count     : 2
// 

#include <stdbool.h>

int fred() {
	int x, z;

	// test waitfor and when

	waitfor( x );

	waitfor( x ) {
	}

	waitfor( x, z ) {
	}

	when( true ) waitfor( x );

	when( true ) waitfor( x ) {
	}

	waitfor( x );
	or waitfor( y );

	waitfor( x, z );
	or waitfor( y );

	when( true ) waitfor( x );
	or when( true ) waitfor( y );

	when( true ) waitfor( x, z );
	or when( true ) waitfor( y );

	waitfor( x ) {
	} or waitfor( y ) {
	}

	waitfor( x, z ) {
	} or waitfor( y ) {
	}

	when( true ) waitfor( x ) {
	} or when( true ) waitfor( y ) {
	}

	waitfor( x );
	or waitfor( y ) {
	}

	when( true ) waitfor( x );
	or when( true ) waitfor( y ) {
	}

	waitfor( x ) {
	} or waitfor( y );

	when( true ) waitfor( x ) {
	} or when( true ) waitfor( y );

	// test when, waitfor and else

	waitfor( x );
	or else;

	when( true ) waitfor( x );
	or else;

	when( true ) waitfor( x, z );
	or else;

	waitfor( x ) {
	} or else {
	}

	when( true ) waitfor( x ) {
	} or else {
	}

	waitfor( x );
	or else {
	}

	when( true ) waitfor( x );
	or else {
	}

	when( true ) waitfor( x, z );
	or else {
	}

	waitfor( x ) {
	} or else;

	when( true ) waitfor( x ) {
	} or else;

	waitfor( x );
	or when( true ) else;

	when( true ) waitfor( x );
	or when( true ) else;

	when( true ) waitfor( x, z );
	or when( true ) else;

	waitfor( x ) {
	} or when( true ) else {
	}

	when( true ) waitfor( x ) {
	} or when( true ) else {
	}

	waitfor( x );
	or when( true ) else {
	}

	when( true ) waitfor( x );
	or when( true ) else {
	}

	when( true ) waitfor( x, z );
	or when( true ) else {
	}

	waitfor( x ) {
	} or when( true ) else;

	when( true ) waitfor( x ) {
	} or when( true ) else;

	// test when, waitfor and timeout

	waitfor( x );
	or timeout( 3 );

	waitfor( x, z );
	or timeout( 3 );

	when( true ) waitfor( x );
	or timeout( 3 );

	waitfor( x ) {
	} or timeout( 3 ) {
	}

	when( true ) waitfor( x ) {
	} or timeout( 3 ) {
	}

	when( true ) waitfor( x, z ) {
	} or timeout( 3 ) {
	}

	when( true ) waitfor( x ) {
	} or when ( true ) timeout( 3 ) {
	}

	when( true ) waitfor( x, z ) {
	} or when ( true ) timeout( 3 ) {
	}

	waitfor( x );
	or timeout( 3 ) {
	}

	when( true ) waitfor( x );
	or timeout( 3 ) {
	}

	when( true ) waitfor( x );
	or when( true ) timeout( 3 ) {
	}

	waitfor( x ) {
	} or timeout( 3 );

	when( true ) waitfor( x ) {
	} or timeout( 3 );

	when( true ) waitfor( x ) {
	} or when( true ) timeout( 3 );

	// test when, waitfor, timeout and else

	waitfor( x ) {
	} or timeout( 3 ) {
	} or when( true ) else {}

	when( true ) waitfor( x ) {
	} or timeout( 3 ) {
	} or when( true ) else {}

	waitfor( x ) {
	} or timeout( 3 ) {
	} or when( true ) else {}

	waitfor( x ) {
	} or when( true ) timeout( 3 ) {
	} or when( true ) else {}

	when( true ) waitfor( x ) {
	} or timeout( 3 ) {
	} or when( true ) else {}

	waitfor( x ) {
	} or when( true ) timeout( 3 ) {
	} or when( true ) else {}

	when( true ) waitfor( x ) {
	} or when( true ) timeout( 3 ) {
	} or when( true ) else {}

	// test quasi-keywords "or" and "timeout"

	int or, timeout;
	waitfor( timeout, 7 ) 3;
	waitfor( timeout, 7 ) 3; or waitfor( timeout, 7 ) 3;
	when( or ) waitfor( or, ) { 4; } or timeout( 1 ) 3;
	when( 3 ) waitfor( or, 2 ) 4; or else 4;
	when( 3 ) waitfor( or, 3 ) 4; or when( or ) timeout( or ) 4; or when( or ) else timeout;
	when( 3 ) waitfor( or, or ) 3; or when( or ) waitfor( or, timeout ) 4; or else 4;
	when( 3 ) waitfor( or, or ) 3; or waitfor( or, 9 ) 4; or when( or ) timeout( timeout ) 4;
	when( 3 ) waitfor( or, 3 ) 3; or waitfor( or, 7 ) or; or timeout( 1 ) or; or when( 3 ) else or;

	// test else selection

	if ( or > timeout ) waitfor( or ) 3;
	else waitfor( timeout ) 4;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa waitfor.c" //
// End: //
