use std::thread;
use std::time::Duration;

// This is the version I wished worked.
// If join was't ingored it would be safe
fn better() {
	// let durr = Duration::from_millis(1);
	{
		let thrd = thread::spawn(move || {
			for i in 1..10 {
				println!("hi number {} from the spawned thread!", i);
				thread::sleep(durr);
			}
		});

		for i in 1..5 {
			println!("hi number {} from the main thread!", i);
			thread::sleep(durr);
		}

		thrd.join().unwrap();
	}
}

use std::sync::Arc;

// This uses arc, which should not be needed
// But it fails to figure out where to clone so it doesn't compile
fn best() {
	let durr = Arc::new(Duration::from_millis(1));
	{
		let thrd = thread::spawn(|| {
			for i in 1..10 {
				println!("hi number {} from the spawned thread!", i);
				thread::sleep(*durr);
			}
		});

		for i in 1..5 {
			println!("hi number {} from the main thread!", i);
			thread::sleep(*durr);
		}

		thrd.join().unwrap();
	}
}

// This is what is actually required
// Note that the clone is explicit
fn real() {
	let durr = Arc::new(Duration::from_millis(1));
	{
		let durr2 = durr.clone();
		let thrd = thread::spawn(move || {
			for i in 1..10 {
				println!("hi number {} from the spawned thread!", i);
				thread::sleep(*durr2);
			}
		});

		for i in 1..5 {
			println!("hi number {} from the main thread!", i);
			thread::sleep(*durr);
		}

		thrd.join().unwrap();
	}
}

fn main() {
	best();
	better();
	real();
}