#include <assert.h>
int main() {
	float a[10];				$\C{// array}$
	float (*pa)[10] = &a;		$\C{// pointer to array}$
	float a0 = a[0];			$\C{// element}$
	float * pa0 = &(a[0]);		$\C{// pointer to element}$

	float * pa0x = a;			$\C{// (ok)}$
	assert( pa0 == pa0x );
	assert( sizeof(pa0x) != sizeof(a) );

	void f( float x[10], float * y ) {
		static_assert( sizeof(x) == sizeof(void *) );
		static_assert( sizeof(y) == sizeof(void *) );
	}
	f(0,0);

	// reusing local var `float a[10];`}
	float v;
	f( a, a );					$\C{// ok: two decays, one into an array spelling}$
	f( &v, &v );				$\C{// ok: no decays; a non-array passes to an array spelling}$

	char ca[] = "hello";		$\C{// array on stack, initialized from read-only data}$
	char * cp = "hello";		$\C{// pointer to read-only data [decay here]}$
	void edit( char c[] ) {		$\C{// parameter is pointer}$
		c[3] = 'p';
	}
	edit( ca );					$\C{// ok [decay here]}$
	edit( cp );					$\C{// Segmentation fault}$
	edit( "hello" );			$\C{// Segmentation fault [decay here]}$

	void decay( float x[10] ) {
		static_assert( sizeof(x) == sizeof(void *) );
	}
	static_assert( sizeof(a) == 10 * sizeof(float) );
	decay(a);

	void no_decay( float (*px)[10] ) {
		static_assert( sizeof(*px) == 10 * sizeof(float) );
	}
	static_assert( sizeof(*pa) == 10 * sizeof(float) );
	no_decay(pa);
}

// Local Variables: //
// compile-command: "sed -f sedcmd bkgd-carray-decay.c | gcc -x c -" //
// End: //
