#pragma once

#include "gcpointers.h"
#include "internal/collector.h"

// forall(otype T)
// static inline gcpointer(T) gcmalloc()
// {
//     gcpointer(T) ptr = { gc_allocate(sizeof(T)) };
//     ptr{};
//     gc_conditional_collect();
//     return ptr;
// }

forall(otype T)
static inline void gcmalloc(gcpointer(T)* ptr)
{
	ptr { gc_allocate(sizeof(T)) };
	get(ptr) {};
      gc_conditional_collect();
}
