set terminal pdf color enhanced size 6.0in,3.0in font "Times,17"
#set terminal postscript portrait enhanced size 7.5, 10. color solid 9.5;
#set terminal wxt size 950,1250

DIR="pictures"

set macros
set output "build/string-graph-allocn.pdf"
#set pointsize 2.0
set grid
set key top left
#set xtics (1,2,5,10,20,50,100,200,500)
set logscale x 2
set logscale y 2
set xlabel "Duration (ns)" offset 2,0
set ylabel "Space Used (byte)"
set linetype 3 dashtype 2
set linetype 4 dashtype 2
plot DIR."/string-graph-allocn.dat" \
	   i 0 using 1:2 title columnheader(1) with linespoints lt rgb "blue"	pt  2  ps 1 lw 1, \
	'' i 1 using 1:2 title columnheader(1) with linespoints lt rgb "red"	pt  3  ps 1 lw 1, \
	'' i 2 using 1:2 title columnheader(1) with linespoints lt rgb "gray"	pt  6  ps 1 lw 1, \
	'' i 3 using 1:2 title columnheader(1) with linespoints lt rgb "yellow"	pt  8  ps 1 lw 1, \
	'' i 4 using 1:2 title columnheader(1) with linespoints lt rgb "cyan"	pt  8  ps 1 lw 1
