#include <kernel>
#include <thread>

#ifdef LONG_TEST
static const unsigned long N = 9_750_000ul;
#else
static const unsigned long N = 325_000ul;
#endif

#ifndef PREEMPTION_RATE
#define PREEMPTION_RATE 10_000ul
#endif

unsigned int default_preemption() {
	return PREEMPTION_RATE;
}

thread worker_t {};

void main(worker_t & this) {
	for(int i = 0; i < N; i++) {
		yield();
	}
}

extern "C" {
static worker_t * workers;
}

int main(int argc, char* argv[]) {
	processor p;
	{
		worker_t w[7];
		workers = w;
	}
}
