//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// swap.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Apr 21 08:10:41 2016
// Update Count     : 69
//

#include <fstream>
#include <stdlib>										// swap

int main( void ) {
	char c1 = 'a', c2 = 'b';
	sout | "char\t\t\t" | c1 | ' ' | c2 | "\t\t\tswap ";
	swap( &c1, &c2 );
	sout | '\t' | c1 | ' ' | c2 | endl;

	signed int i1 = -1, i2 = -2;
	sout | "signed int\t\t" | i1 | i2 | "\t\t\tswap ";
	swap( &i1, &i2 );
	sout | '\t' | i1 | i2 | endl;

	unsigned int ui1 = 1, ui2 = 2;
	sout | "unsigned int\t\t" | ui1 | ui2 | "\t\t\tswap ";
	swap( &ui1, &ui2 );
	sout | '\t' | ui1 | ui2 | endl;

	signed long int li1 = -1, li2 = -2;
	sout | "signed long int\t\t" | li1 | li2 | "\t\t\tswap ";
	swap( &li1, &li2 );
	sout | '\t' | li1 | li2 | endl;

	unsigned long int uli1 = 1, uli2 = 2;
	sout | "unsigned long int\t" | uli1 | uli2 | "\t\t\tswap ";
	swap( &uli1, &uli2 );
	sout | '\t' | uli1 | uli2 | endl;

	signed long long int lli1 = -1, lli2 = -2;
	sout | "signed long long int\t" | lli1 | lli2 | "\t\t\tswap ";
	swap( &lli1, &lli2 );
	sout | '\t' | lli1 | lli2 | endl;

	unsigned long long int ulli1 = 1, ulli2 = 2;
	sout | "unsigned long long int\t" | ulli1 | ulli2 | "\t\t\tswap ";
	swap( &ulli1, &ulli2 );
	sout | '\t' | ulli1 | ulli2 | endl;

	float f1 = 1.5, f2 = 2.5;
	sout | "float\t\t\t" | f1 | f2 | "\t\t\tswap ";
	swap( &f1, &f2 );
	sout | '\t' | f1 | f2 | endl;

	double d1 = 1.5, d2 = 2.5;
	sout | "double\t\t\t" | d1 | d2 | "\t\t\tswap ";
	swap( &d1, &d2 );
	sout | '\t' | d1 | d2 | endl;

	long double ld1 = 1.5, ld2 = 2.5;
	sout | "long double\t\t" | ld1 | ld2 | "\t\t\tswap ";
	swap( &ld1, &ld2 );
	sout | '\t' | ld1 | ld2 | endl;

	float _Complex fc1 = 1.5f+1.5if, fc2 = 2.5f+2.5if;
	sout | "float _Complex\t\t" | fc1 | fc2 | "\tswap ";
	swap( &fc1, &fc2 );
	sout | '\t' | fc1 | fc2 | endl;

	double _Complex dc1 = 1.5d+1.5id, dc2 = 2.5d+2.5id;
	sout | "double _Complex\t\t" | dc1 | dc2 | "\tswap ";
	swap( &dc1, &dc2 );
	sout | '\t' | dc1 | dc2 | endl;

	long double _Complex ldc1 = 1.5d+1.5il, ldc2 = 2.5d+2.5il;
	sout | "long double _Complex\t" | ldc1 | ldc2 | "\tswap ";
	swap( &ldc1, &ldc2 );
	sout | '\t' | ldc1 | ldc2 | endl;

	struct S { int i, j; } s1 = { 1, 2 }, s2 = { 2, 1 };
	ofstream * ?|?( ofstream * os, S s ) { return os | s.i | s.j; }
	sout | "struct S\t\t" | s1 | "," | s2 | "\t\tswap ";
	swap( &s1, &s2 );
	sout | '\t' | s1 | "," | s2 | endl;
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa swap.c" //
// End: //
