#pragma once

typedef char char_t;

//######################### HandleNode #########################
struct VbyteHeap_t;

struct HandleNode_t
{
	char_t* string;
	unsigned short int length;

	HandleNode_t* next;
	HandleNode_t* previous;
};

static inline void ctor(HandleNode_t* const this);
static inline void ctor(HandleNode_t* const this, VbyteHeap_t* heap);
static inline void dtor(HandleNode_t* const this);

void DeleteNode(HandleNode_t* const this);
void AddThisAfter(HandleNode_t* const this, HandleNode_t* other);

void MoveThisAfter(HandleNode_t* const this, const HandleNode_t* rhs);
void MoveThisBefore(HandleNode_t* const this, const HandleNode_t* rhs);

//######################### VbyteHeap #########################

struct VbyteHeap
{
	HandleNode_t Header;

	int NoOfCompactions;
	int NoOfExtensions;
	int NoOfReductions;

	int InitSize;
	int CurrSize;
	char_t* StartVbyte;
	char_t* EndVbyte;
	void* ExtVbyte;
};

static inline void ctor(VbyteHeap* const this, int size);
static inline void dtor(VbyteHeap* const this);

void compaction(VbyteHeap* const this);
void garbage(VbyteHeap* const this);
void extend(VbyteHeap* const this, int);
void reduce(VbyteHeap* const this, int);

static inline ctor(HandleNode_t* const this)
{
	this->string = (void*)0;
	this->length = 0;
}

static inline ctor(HandleNode_t* const this, VbyteHeap* vh)
{
	this->string = (void*)0;
	this->length = 0;
	HandleNode_t* const node = &vh->Header;
	AddThisAfter(this, node->previous);
}

static inline dtor(HandleNode_t* const this)
{
	DeleteNode(this);
}
