//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FixNames.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Mon Apr 11 15:38:10 2016
// Update Count     : 1
//

#include "FixNames.h"
#include "SynTree/Declaration.h"
#include "SynTree/Expression.h"
#include "SynTree/Visitor.h"
#include "SymTab/Mangler.h"
#include "OperatorTable.h"

namespace CodeGen {
	class FixNames : public Visitor {
	  public:
		virtual void visit( ObjectDecl *objectDecl );
		virtual void visit( FunctionDecl *functionDecl );

		virtual void visit( CompoundStmt *compoundStmt );

	  private:
		int scopeLevel = 1;

		void fixDWT( DeclarationWithType *dwt );
	};

	void fixNames( std::list< Declaration* > translationUnit ) {
		FixNames fixer;
		acceptAll( translationUnit, fixer );
	}

	void FixNames::fixDWT( DeclarationWithType *dwt ) {
		if ( dwt->get_name() != "" ) {
			if ( LinkageSpec::isDecoratable( dwt->get_linkage() ) ) {
				dwt->set_mangleName( SymTab::Mangler::mangle( dwt ) );
				dwt->set_scopeLevel( scopeLevel );
			} // if
		} // if
	}

	void FixNames::visit( ObjectDecl *objectDecl ) {
		Visitor::visit( objectDecl );
		fixDWT( objectDecl );
	}

	void FixNames::visit( FunctionDecl *functionDecl ) {
		Visitor::visit( functionDecl );
		fixDWT( functionDecl );
	}

	void FixNames::visit( CompoundStmt *compoundStmt ) {
		scopeLevel++;
		Visitor::visit( compoundStmt );
		scopeLevel--;
	}
} // namespace CodeGen

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
