//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TupleExpansionNew.cpp --
//
// Author           : Henry Xue
// Created On       : Wed Aug 18 12:54:02 2021
// Last Modified By : Henry Xue
// Last Modified On : Wed Aug 18 12:54:02 2021
// Update Count     : 1
//

// Currently not working due to unresolved issues with UniqueExpr

#include "Tuples.h"

namespace Tuples {
namespace {
	struct UniqueExprExpander final : public ast::WithDeclsToAdd<> {
		const ast::Expr * postvisit( const ast::UniqueExpr * unqExpr );
		std::map< int, const ast::Expr * > decls; // not vector, because order added may not be increasing order
	};
} // namespace

void expandUniqueExpr( ast::TranslationUnit & translationUnit ) {
	ast::Pass< UniqueExprExpander >::run( translationUnit );
}

namespace {
	const ast::Expr * UniqueExprExpander::postvisit( const ast::UniqueExpr * unqExpr ) {
		const CodeLocation loc = unqExpr->location;
		const int id = unqExpr->id;

		// on first time visiting a unique expr with a particular ID, generate the expression that replaces all UniqueExprs with that ID,
		// and lookup on subsequent hits. This ensures that all unique exprs with the same ID reference the same variable.
		if ( ! decls.count( id ) ) {
			ast::ptr< ast::Expr > assignUnq;
			ast::ptr< ast::VariableExpr > var = unqExpr->var;
			if ( unqExpr->object ) {
				// an object was generated to represent this unique expression -- it should be added to the list of declarations now
				declsToAddBefore.push_back( unqExpr->object.as< ast::Decl >() );
				// deep copy required due to unresolved issues with UniqueExpr
				assignUnq = ast::UntypedExpr::createAssign( loc, var, ast::deepCopy( unqExpr->expr.get() ) );
			} else {
				ast::ptr< ast::Expr > expr = unqExpr->expr;
				ast::ptr< ast::CommaExpr > commaExpr = expr.strict_as< ast::CommaExpr >();
				assignUnq = commaExpr->arg1;
			}
			auto finished = new ast::ObjectDecl( loc, toString( "_unq", id, "_finished_" ), new ast::BasicType( ast::BasicType::Kind::Bool ),
				new ast::SingleInit( loc, ast::ConstantExpr::from_int( loc, 0 ) ), {}, ast::Linkage::Cforall );
			declsToAddBefore.push_back( finished );
			// (finished ? _unq_expr_N : (_unq_expr_N = <unqExpr->get_expr()>, finished = 1, _unq_expr_N))
			// This pattern ensures that each unique expression is evaluated once, regardless of evaluation order of the generated C code.
			auto assignFinished = ast::UntypedExpr::createAssign( loc, new ast::VariableExpr( loc, finished ),
				ast::ConstantExpr::from_int( loc, 1 ) );
			auto condExpr = new ast::ConditionalExpr( loc, new ast::VariableExpr( loc, finished ), var,
				new ast::CommaExpr( loc, new ast::CommaExpr( loc, assignUnq, assignFinished ), var ) );
			condExpr->result = var->result;
			condExpr->env = unqExpr->env;
			decls[id] = condExpr;
		}
		//delete unqExpr;
		return decls[id];
	}
} // namespace
} // namespace Tuples
