//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// XXX.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : 
// Last Modified On : 
// Update Count     : 0
//
#include <iostream>
#include <strstream>

#include "LabelGenerator.h"

namespace ControlStruct {
    LabelGenerator *LabelGenerator::labelGenerator = 0;

    LabelGenerator *LabelGenerator::getGenerator() {
	if ( LabelGenerator::labelGenerator == 0 )
	    LabelGenerator::labelGenerator = new LabelGenerator();

	return labelGenerator;
    }

    Label LabelGenerator::newLabel() {
	std::ostrstream os;
	os << "__L" << current++ << "__";// << std::ends;
	os.freeze( false );
	std::string ret = std::string (os.str(), os.pcount());
	return Label( ret );
    }
} // namespace ControlStruct
// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
