//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// XXX.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : 
// Last Modified On : 
// Update Count     : 0
//
#include "SynTree/Mutator.h"
#include "SynTree/Statement.h"
#include "ForExprMutator.h"

namespace ControlStruct {
    Statement *ForExprMutator::mutate( ForStmt *forStmt ) {
	// recurse down all nest for loops to hoist any initializer declarations to make them C89 (rather than C99)
    	forStmt->set_body( forStmt->get_body()->acceptMutator( *this ) );
	if ( DeclStmt *decl = dynamic_cast< DeclStmt * > ( forStmt->get_initialization() ) ) {
	    // create compound statement, move initializer declaration outside, leave _for_ as-is
	    CompoundStmt *block = new CompoundStmt( std::list< Label >() );
	    std::list<Statement *> &stmts = block->get_kids();

	    stmts.push_back( decl );
	    forStmt->set_initialization( 0 );
	    stmts.push_back( forStmt );

	    return block;
	} // if

	return forStmt;
    }
} // namespace ControlStruct
// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
