#
# Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
#
# The contents of this file are covered under the licence agreement in the
# file "LICENCE" distributed with Cforall.
#
# prototypes.awk -- 
#
# Author           : Peter A. Buhr
# Created On       : Sat May 16 07:57:37 2015
# Last Modified By : Peter A. Buhr
# Last Modified On : Sat May 16 08:02:10 2015
# Update Count     : 3
# 

# http://llvm.org/svn/llvm-project/cfe/trunk/include/clang/Basic/Builtins.def

BEGIN {
    FS = "("
    # order so string search is longest string
    types[0]  = "UINTMAX";					vtypes[0]  = "unsigned long int"
    types[1]  = "UINT16";					vtypes[1]  = "short int"
    types[2]  = "UINT32";					vtypes[2]  = "int"
    types[3]  = "UINT64";					vtypes[3]  = "long long int"
    types[4]  = "UINT";						vtypes[4]  = "unsigned int"
    types[5]  = "INTMAX";					vtypes[5]  = "long int"
    types[6]  = "INTPTR";					vtypes[6]  = "int *"
    types[7]  = "WINT";						vtypes[7]  = "unsigned int"
    types[8]  = "INT";						vtypes[8]  = "int"
    types[9]  = "ULONGLONG";				vtypes[9]  = "unsigned long long"
    types[10] = "ULONG";					vtypes[10] = "unsigned long"
    types[11] = "UNSIGNED";					vtypes[11] = "unsigned"
    types[12] = "COMPLEX_LONGDOUBLE";		vtypes[12] = "_Complex long double"
    types[13] = "COMPLEX_DOUBLE";			vtypes[13] = "_Complex double"
    types[14] = "COMPLEX_FLOAT";			vtypes[14] = "_Complex float"
    types[15] = "LONGDOUBLEPTR";			vtypes[15] = "long double *"
    types[16] = "LONGDOUBLE";				vtypes[16] = "long double"
    types[17] = "LONGLONG";					vtypes[17] = "long long"
    types[18] = "LONG";						vtypes[18] = "long"
    types[19] = "DFLOAT32";					vtypes[19] = "_Decimal32"
    types[20] = "DFLOAT64";					vtypes[20] = "_Decimal64"
    types[21] = "DFLOAT128";				vtypes[21] = "_Decimal128"
    types[22] = "DOUBLEPTR";				vtypes[22] = "double *"
    types[23] = "DOUBLE";					vtypes[23] = "double"
    types[24] = "FLOATPTR";					vtypes[24] = "float *"
    types[25] = "FLOAT";					vtypes[25] = "float"
    types[26] = "CONST_PTR";				vtypes[26] = "const void *"
    types[27] = "CONST_STRING";				vtypes[27] = "const char *"
    types[28] = "PTR_FN_VOID_VAR_PTR_SIZE";	vtypes[28] = ""
    types[29] = "PTR_CONST_STRING";			vtypes[29] = "char *const"
    types[30] = "PTRMODE_PTR";				vtypes[30] = ""
    types[31] = "PTRPTR";					vtypes[31] = "void **"
    types[32] = "PTR";						vtypes[32] = "void *"
    types[33] = "VOID";						vtypes[33] = "void"
    types[34] = "STRING";					vtypes[34] = "char *"
    types[35] = "FILEPTR";					vtypes[35] = "struct _IO_FILE *"
    types[36] = "SIZE";						vtypes[36] = "unsigned long"
    types[37] = "VAR";						vtypes[37] = "..."
    types[38] = "VALIST_ARG";				vtypes[38] = "void **"
    types[39] = "VALIST_REF";				vtypes[39] = "void **"
    types[40] = "UNWINDWORD";				vtypes[40] = "void *"
    types[41] = "WORD";						vtypes[41] = ""
    types[42] = "SSIZE";					vtypes[42] = "long int"
    types[43] = "PID";						vtypes[43] = "int"
    N = 44
} # BEGIN

/^BT_/ { prototypes[$1] = $1 }

END {
    printf( "#define DEF_BUILTIN(ENUM, NAME, CLASS, TYPE, LIBTYPE, BOTH_P, FALLBACK_P, NONANSI_P, ATTRS, IMPLICIT, COND) TYPE(NAME)\n" );
    printf( "#define FUNC_SIMPLE(RETURN, NAME, ARGS...) RETURN NAME(ARGS);\n" );
    printf( "#define BT_LAST(NAME) FUNC_SIMPLE(void, NAME)\n\n" );

    # generate C types for macros names
    for ( i = 0; i < N; i += 1 ) {
		printf( "#define BT_%s %s\n", types[i], vtypes[i] )
    } # for
    printf( "\n" )

    for ( prototype in prototypes ) {
		if ( index( "BT_LAST", prototype ) == 1 ) {
			continue
		} # if

		printf( "#define %s(NAME) FUNC_SIMPLE(", prototype )

		if ( sub( "BT_FN_", "", prototype ) == 0 ) {
			printf( "\n********** BAD MACRO NAME \"%s\" **********\n", prototype )
			exit 0
		} # if

		# generate function return type as macro
		for ( t = 0; t < N; t += 1 ) {					# find longest match 
			type = types[t];
			if ( index( prototype, type ) == 1 ) {		# found match
				printf( "BT_%s, NAME", type )
				sub( type, "", prototype )
				break;
			} # if
		} # for

		# generate function parameter types as macro
		if ( index( prototype, "VAR" ) != 2 ) {			# C-style empty parameters ?
			for ( p = 0; length( prototype ) > 0; p += 1 ) { # until all parameters types are removed
				sub( "_", "", prototype)				# remove "_"
				printf( ", ", type )
				temp = prototype
				for ( t = 0; t < N; t += 1 ) {			# find longest match
					type = types[t];
					if ( index( prototype, type ) == 1 ) { # found match
						printf( "BT_%s", type )
						sub( type, "", prototype )
						break;
					} # if
				} # for
				if ( temp == prototype ) {				# no match found for parameter in macro table
					printf( "\n********** MISSING TYPE \"%s\" **********\n", prototype )
					exit 0
				} # if
			} # for
		} # if
		printf( ")\n" )
    } # for

    # extras
    printf( "\n#include \"builtins.def\"\n\n" );
    printf( "typedef void ** __builtin_va_list;\n" );
    printf( "extern const char *__PRETTY_FUNCTION__;\n" );
    printf( "typedef int wchar_t;\n" );
} # END

# Local Variables: #
# tab-width: 4 #
# mode: awk #
# compile-command: "make install" #
# End: #
