// Conditional Match (or Re-Raise)

class EmptyException extends Exception {}

public class CondMatch {
	static boolean should_catch = false;

	static void throw_exception() throws EmptyException {
		throw new EmptyException();
	}

	static void cond_catch() throws EmptyException {
		try {
			throw_exception();
		} catch (EmptyException exc) {
			if (!should_catch) {
				throw exc;
			}
		}
	}

	public static void main(String[] args) {
		int times = 1;
		if (0 < args.length) {
			times = Integer.parseInt(args[0]);
		}
		if (1 < args.length) {
			should_catch = 0 != Integer.parseInt(args[1]);
		}

		long startTime = System.nanoTime();
		for (int count = 0 ; count < times ; ++count) {
			try {
				cond_catch();
			} catch (EmptyException exc) {
				// ...
			}
		}
		long endTime = System.nanoTime();
		System.out.println("Run-Time (ns) " + (endTime - startTime));
	}
}
