#include <fstream>
#include <stdlib>
#include "bench.h"
#include "cfa-stack.h"
#include "cfa-pair.h"
#include "cfa-print.h"

int main( int argc, char * argv[] ) {
	ofstream out = { "/dev/null" };
	int max = 0, val = 42;
	stack( int ) si, t;

	REPEAT_TIMED( "push_int", N, push( si, val ); )
	TIMED( "copy_int", t = si; )
	TIMED( "clear_int", clear( si ); )
	REPEAT_TIMED( "pop_int", N, int x = pop( t ); max = max( x, max ); )
	REPEAT_TIMED( "print_int", N/2, out | val | ':' | val | endl; )

	pair( _Bool, char ) max = { (_Bool)0, '\0' }, val = { (_Bool)1, 'a' };
	stack( pair( _Bool, char ) ) s, t;

	REPEAT_TIMED( "push_pair", N, push( s, val ); )
	TIMED( "copy_pair", t = s; )
	TIMED( "clear_pair", clear( s ); )
	REPEAT_TIMED( "pop_pair", N, pair(_Bool, char) x = pop( t ); max = max( x, max ); )
	REPEAT_TIMED( "print_pair", N/2, out | val | ':' | val | endl; )
}
